//
//  TTTLogger.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 11/24/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTLogger.h"
#import "TTTEncryptionTransformer.h"
#import "TTTLogEntry.h"

#define TTTLOGFILENAME "TTTLogger.txt"

@implementation TTTLogger
    static TTTLogger* singletonLogger=nil;

    +(TTTLogger *) CreateLogger{
        @synchronized([TTTLogger class]){
            if (singletonLogger == nil){
                singletonLogger = [[TTTLogger alloc] init];
                singletonLogger->loggerAppDelegate =
                    (TTTAppDelegate*)[[UIApplication sharedApplication] delegate];
                // Load the Core Data context
                singletonLogger->managedObjectContext =
                    [singletonLogger->loggerAppDelegate managedObjectContext];
            }
            return singletonLogger;
        }
    }

    -(void) log :(NSString *) anEntry{
    
        NSDate *myDate = [[NSDate alloc] init];
        NSDateFormatter *dateFormat = [[NSDateFormatter alloc] init];

        [dateFormat setDateFormat:@"YYYY/MM/dd, hh:mm aa"];

        NSString *aDateStamp = [dateFormat stringFromDate:myDate];

        TTTLogEntry *logEntryObject = [NSEntityDescription insertNewObjectForEntityForName:@"TTTLogEntry"
                                                  inManagedObjectContext:self->managedObjectContext];
	
        [logEntryObject setDateStamp :aDateStamp];
        [logEntryObject setEntry :anEntry];

        NSError *error = nil;
        [managedObjectContext save:&error];
    }

    - (NSArray *) getAllLogEntries {
        NSEntityDescription *logEntryEntity = [NSEntityDescription entityForName:@"TTTLogEntry"     inManagedObjectContext: managedObjectContext];
        NSFetchRequest *request = [[NSFetchRequest alloc] init];
        [request setEntity: logEntryEntity];
    
        NSError *error = nil;
        NSArray *results = [managedObjectContext executeFetchRequest:request error:&error];
        return results;
    }

    - (void) writeLogToNSLog {
        NSArray *logEntries = [self getAllLogEntries];
        for(int i=0; i < [logEntries count]; i++){
            TTTLogEntry *oneLogEntry = [logEntries objectAtIndex:i];
            NSLog(@"Log Entry %d. >%@< >%@<", i, [oneLogEntry dateStamp], [oneLogEntry entry]);
        }
    }

    -(void) terminateLogging{
        self->managedObjectContext = nil;
        self->loggerAppDelegate = nil;
    }

@end
